from OpenGL.GL import *
from glew import *
from pygame.locals import *
import pygame

vertsource = """

void main() {
    vec3 normal, lightDir;
    vec4 diffuse;
    float NdotL;

    normal = normalize(gl_NormalMatrix * gl_Normal);

    lightDir = normalize(vec3(gl_LightSource[0].position));

    NdotL = max(dot(normal, lightDir), 0.0);

    diffuse = gl_FrontMaterial.diffuse * gl_LightSource[0].diffuse;

    gl_FrontColor = NdotL * diffuse;

    gl_Position = gl_ProjectionMatrix * gl_ModelViewMatrix * gl_Vertex;
}

"""

fragsource = """

uniform vec4 col;

void main(void) {
   gl_FragColor = gl_Color + col;
}

"""

pygame.init()
screen = pygame.display.set_mode((640, 480), OPENGL | DOUBLEBUF)

glewInit()
glewGetExtension("GL_ARB_fragment_shader")
glewGetExtension("GL_ARB_vertex_shader")
glewGetExtension("GL_ARB_shader_objects")
glewGetExtension("GL_ARB_shading_language_100")
          
vertshader = glCreateShaderObjectARB(GL_VERTEX_SHADER_ARB)
glFlush()
glShaderSourceARB(vertshader, 1, [vertsource])
glFlush()

glCompileShaderARB(vertshader)
glGetObjectParameterivARB(vertshader, GL_OBJECT_COMPILE_STATUS_ARB)
print glGetInfoLogARB(vertshader)


fragshader = glCreateShaderObjectARB(GL_FRAGMENT_SHADER_ARB)
glFlush()
glShaderSourceARB(fragshader, 1, [fragsource])
glFlush()
glCompileShaderARB(fragshader)
glGetObjectParameterivARB(fragshader, GL_OBJECT_COMPILE_STATUS_ARB)
print glGetInfoLogARB(fragshader)

program = glCreateProgramObjectARB()
glFlush()

glAttachObjectARB(program, vertshader)
glFlush()

glAttachObjectARB(program, fragshader)
glFlush()

glLinkProgramARB(program)
glFlush()

print glGetInfoLogARB(program)
glFlush()


glEnable(GL_LIGHTING)
glEnable(GL_COLOR_MATERIAL)

glUseProgramObjectARB(program)
glFlush()

frame = 0
while 1:
    event = pygame.event.poll()
    if event.type == QUIT: break

    loc = glGetUniformLocationARB(program, 'col')
    assert loc != -1
    glFlush()
    #glUniform1fARB(loc, 1.0)
    glUniform4fARB(loc, 0.0, 0.0, 1.0 * (frame % 2), 0.0)
    glFlush()

    glColor3f(0.5, 0, 0)
    glBegin(GL_QUADS)
    glNormal3f(0, 0, 1)
    glVertex3f(-1, -1, -1)
    glVertex3f(-1, 1, -1)
    glVertex3f(1, 1, -1)
    glVertex3f(1, -1, -1)    
    glEnd()

    pygame.display.flip()
    frame += 1
